import { Router } from 'express';
import { customersController } from './controller';
import { authenticateUser, requireVendor } from '@/middlewares/auth';
import { checkFeature } from '@/middlewares/featureGate';
import { vendorService } from '@/modules/vendors/service';

const router = Router();

// Attach vendor to req for downstream use
async function attachVendor(req: any, res: any, next: any) {
  if (req.user) {
    const { data: vendor } = await vendorService.getVendorByUserId(req.user.id);
    req.vendor = vendor || null;
  }
  next();
}

router.get('/', authenticateUser, requireVendor, attachVendor, checkFeature('customer_management'), customersController.list);
router.post('/', authenticateUser, requireVendor, attachVendor, checkFeature('customer_management'), customersController.addOrLink);
router.get('/:customerId', authenticateUser, requireVendor, attachVendor, checkFeature('customer_management'), customersController.getProfile);
router.put('/:customerId', authenticateUser, requireVendor, attachVendor, checkFeature('customer_management'), customersController.update);
router.post('/:customerId/measurements', authenticateUser, requireVendor, attachVendor, checkFeature('customer_management'), customersController.upsertMeasurements);
router.delete('/:customerId', authenticateUser, requireVendor, attachVendor, checkFeature('customer_management'), customersController.unlink);

export default router; 